import { Document, Types } from 'mongoose'

import { Comment } from './comment'
import { ShortUserExport } from './user'

/** Post stored in the database */
export interface PostExport extends Document {
    /** Id generated by MongoDB */
    _id: Types.ObjectId;

    /** Title of the post */
    title: string;

    /** Picture of the post */
    picture: string;

    /** Description associated to the post */
    description: string;

    /** Creator of the post */
    comments: Comment[];

    /** All the like related to the post */
    likes: ShortUserExport[];

    /** Number of likes */
    likesNumber: number;

    /** Number of comments */
    commentsNumber: number;

    /** List of all the user's posts */
    author: ShortUserExport;
}

export function copy(post: PostExport): PostExport {
    return {
        _id: post._id,
        title: post.title,
        picture: post.picture,
        description: post.description,
        comments: post.comments,
        likes: post.likes,
        likesNumber: post.likesNumber,
        commentsNumber: post.commentsNumber,
        author: post.author
    } as PostExport;
}

/** Representation of a new post */
export interface PostCandidate extends Omit<PostExport, '_id'> { }

