import { Types, Document } from 'mongoose'

/** User stored in database */
export interface UserExport extends Document {
    /** Id generated by MongoDB */
    _id: Types.ObjectId;

    /** Pseudo of the user */
    pseudo: string;

    /** Picture representing the user */
    avatar: string;

    /** Contact of the user */
    email: string;

    /** List of all the user's posts */
    posts: Types.ObjectId[];

    /** Number of posts */
    postsNumber: number;

    token: string;

    validatePassword(password: string): boolean;
    generateJWT(): string;
    toAuth(): string;
    setPassword(password: string): void;
}

export function copy(user: UserExport): UserExport {
    return {
        _id: user._id,
        pseudo: user.pseudo,
        avatar: user.avatar,
        email: user.email,
        posts: user.posts,
        postsNumber: user.postsNumber
    } as UserExport;
}

/** Representation of a new user */
export interface UserCandidate extends Pick<UserExport, 'email' | 'pseudo'> {
    password: string;
}


/** User represented as an author. Minimum information are displayed. */
export interface ShortUserExport extends Pick<UserExport, '_id' | 'avatar' | 'pseudo'> { }
